// Score.java
// Version 0.4 
// Last Updated: 10/13/2000
// Used by RecommendationManager

// Change Log
// BWL101100 - Added insertRecommendation
// BWL101300 - Modified to accomodate eight different scoring functions 

package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import java.sql.*;
import java.math.*;
import oracle.jdbc.driver.*;

import Alkindi.BusinessServices.*;
import Alkindi.BusinessServices.Util.*;
import Alkindi.BusinessDataTypes.*;

public class Score
{

	static int PARAM_NO_PRODUCTS_MEET_CRITERIA = 1;

	RecMgrDBUtils redb = new RecMgrDBUtils();

	public long getProductToRecommend(SystemUser su, int pcid, ArrayList rpl, int scoringFunction) 
			throws AlkExcept{

		// Default return product is zero; will be caught if still zero after sp
		//
		long PTR = 0;
//		LogManager.dbgLog("Score", "getProductToRecommend", "Score.getProductToRecommend(): called with uid=" + su.id + " pcid = " + pcid + " ScoringFcn = " + ScoringFunction);
		Connection con = null;

		try
		{
			AlkConn ac = new AlkConn();
			con = ac.getConnection();
	//Filtering Rules built in this stored procedure:
						//1. Filter out the product that the user has already rated.
						//2. The products with average rating within the user's cluster for movie is below a1(a tunable
			//	paramter). 
			//
			CallableStatement cs = 
				con.prepareCall("{ call  pkg_ALKINDI_RECOMMENDATION.sp_SEL_PROD_BY_USER_PC_SF(?,?,?,?,?,?)}");  

			cs.setLong (1, su.id);
			cs.setInt (2, scoringFunction);
			cs.setInt (3, pcid);
			cs.setInt (4, AlkParam.PARAM_REM_B6);
			cs.registerOutParameter(5, OracleTypes.CURSOR );
			cs.registerOutParameter(6, Types.INTEGER );	
			cs.execute();
			ResultSet rs = ( (OracleCallableStatement)cs).getCursor(5); 
			int error = cs.getInt(6);
			int a = 0;
			switch (error)
			{
				case  0:
//					LogManager.dbgLog("Score", "getProductToRecommend", "Score.getProductToRecommend() Got list of recommendable products; processing rules.");
				while ((a < 1) && (rs.next())){
					long productid = rs.getLong(ac.DBCOLPID);
//						LogManager.dbgLog("Score", "getProductToRecommend", "Product #" + productid + "...");
					FilteringRules FR = new FilteringRules();
					boolean BF = FR.getFiltered(su, productid, rpl);
					if (BF == false){
//							LogManager.dbgLog("Score", "getProductToRecommend", "OK.");
						PTR = productid;
						a = 2;
						break;
					}
					else {
//							LogManager.dbgLog("Score", "getProductToRecommend", "flunked rule test.");
						a = 0;
					}
				} //while
			break;
				case -1:
			throw new AlkExcept("Error in Retrieving Values",6012);
		  }

		rs.close();
		cs.close();

		} 
		catch(AlkExcept ae) {
			throw ae;
		}
		catch(SQLException se) 
		{
			throw new AlkExcept("SQL Exception in Score.getProductToRecommend. Message: " + se.getMessage(),6004);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2512);
		}
		finally {
			try { con.close(); } catch(Exception e) {}
		}
		return PTR;
	}
}
